function P81_iii
% Problem 8.1 :	Nonlinear parametric pendulum
% Part iii. Period doubling

% Define some constants
omega0=1;       % Natural frequency of the pendulum
gamma=0.1;      % Damping coefficient
h=[ 1.50 1.80 2.00 2.05 2.062];  % Five amplitudes of forcing

% Define some parameters for using Runge-Kutta metod
tspan=[0 500];      % Time span to be obtained
theta0=[3,0];    % Initial conditions

% Choose time step smaller than 0.01 sec
optn=odeset('InitialStep',1e-2,'MaxStep',1e-2);

% Define plot color set
col={'r' ; 'b' ; 'g' ; 'm' ; 'c'};

for i=1:length(h)
    % Simulation with different h
    [T,Y]=ode45(@(t,x) Npp(t,x,gamma,omega0,h(i)),tspan,theta0,optn);
    % Remove transient response (remove data smaller than 100 second)
    Y=Y(find(T>=100),:);
    T=T(find(T>=100),:);
    % Generate figure
    figure(i); 
    % Plot steady state response for given h
    subplot(2,1,1); plot(T,Y(:,1),col{i});
    grid on; axis tight;
    xlabel('\bfTime (second)');
    ylabel('\bfAngular Position \theta (rad)');
    title(['\bfSteady State Response (t,\theta) for given h=' num2str(h(i))]);    
    % Plot phase space for given h
    % Use mod for the angular position (-pi<=theta<=+pi)
    subplot(2,1,2); p=plot(pi-mod(Y(:,1),2*pi),Y(:,2),[col{i} '.']);
    set(p,'MarkerSize',2);
    grid on; axis tight;
    xlabel('\bfAngular Position \theta (rad)');
    ylabel('\bfAngular Velocity d\theta/dt(rad/sec)');
    title(['\bfPhase Space (\theta,d\theta/dt) for given h=' num2str(h(i))]);
end
end

function dx=Npp(t,x,gamma,omega0,h)
% Describe nonlinear parametric pendulum motion
dx(1,1)=x(2);
dx(2,1)=-2*gamma*x(2)-omega0^2*(1+h*cos(2*omega0*t))*sin(x(1));
end